<?php
	$siparisBul = $db->query("SELECT * FROM siparisler WHERE siparisID=?", array(get("siparisID")));
	if(!$siparisBul){
		header("Location: " . url());
		die();
	}else{
		$_SESSION["siparisDetay"] = $siparisBul[0]["siparisID"];
		$urunBul = $db->query("SELECT * FROM urunler WHERE ID=?", array($siparisBul[0]["urunID"]));
	}
?>
<!doctype html>
<html lang="tr">
   <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <title>Sipariş Detayları | <?=title();?></title>
	  <meta name="robots" content="noindex">
      <link href="https://fonts.googleapis.com/css2?family=Rubik:wght@400;500&display=swap" rel="stylesheet">
      <link rel="stylesheet" href="<?=theme();?>css/bootstrap.min.css"/>
      <link rel="stylesheet" href="<?=theme();?>css/fontawesome.css"/>
      <link rel="stylesheet" href="<?=theme();?>osmaniyecicekcim.css"/>
      <script type="text/javascript" src="<?=theme();?>js/jquery-3.0.1.min.js"></script>
	  <?=siteAnalytics();?>
   </head>
   <body>
      <?php
         include "HEADER.php";
          ?>
      <section class="dynamic-pages">
         <div class="container">
			<?php
				if(pisset("notDegistir")){
					$notGuncelle = $db->query("UPDATE siparisler SET musterinot=? WHERE siparisID=?", array(post("mNotu"), $siparisBul[0]["siparisID"]));
					if($notGuncelle){
						header("Location: " . url() . 'siparis-detaylari?siparisID=' . $siparisBul[0]["siparisID"] . '&notdegistirildi');
					}
				}
				if(pisset("adresDegistir")){
					$notGuncelle = $db->query("UPDATE siparisler SET aliciadres=?, ilce=? WHERE siparisID=?", array(post("aliciadres"), post("ilce"), $siparisBul[0]["siparisID"]));
					if($notGuncelle){
						header("Location: " . url() . 'siparis-detaylari?siparisID=' . $siparisBul[0]["siparisID"] . '&adresdegistirildi');
					}
				}
				if(gisset("notdegistirildi")){
					echo adminmesaj1("Sipariş notu değiştirildi.");
				}
				if(gisset("adresdegistirildi")){
					echo adminmesaj1("Adres bilgisi değiştirildi.");
				}
			?>
			<article class="card">
				<header class="card-header bg-dark text-white">Sipariş Detayı - <?=adminOdemeYontemi($siparisBul[0]["odemeYontemi"]);?></header>
				<div class="card-body">
					<h6>Sipariş Numarası: <?=$siparisBul[0]["siparisID"];?></h6>
					<article class="card">
						<div class="card-body row text-center">
							<div class="col-lg-3"> <strong>Sipariş Tarihi - Saati:</strong> <br><?=$siparisBul[0]["siparisTarihi"]?> </div>
							<div class="col-lg-3"> <strong>Sipariş Durumu:</strong> <br> <?=siparisDurumu($siparisBul[0]["durum"]);?> </div>
							<div class="col-lg-3"> <strong>Gönderici:</strong> <br> <?=$siparisBul[0]["adsoyad"]?> | <i class="fa fa-phone"></i> <?=$siparisBul[0]["telefon"]?> </div>
							<div class="col-lg-3"> <strong>Alıcı:</strong> <br> <?=$siparisBul[0]["aliciadsoyad"]?> | <i class="fa fa-phone"></i> <?=$siparisBul[0]["alicitelefon"]?> </div>
						</div>
					</article>
					<div class="track">
						<div class="step active"> <span class="icon"> <i class="fa fa-check "></i> </span> <span class="text"><small>Oluşturuldu</small></span> </div>
						<div class="step <?php
							if($siparisBul[0]["durum"] == 1 OR $siparisBul[0]["durum"] == 2 OR $siparisBul[0]["durum"] == 3){
								echo 'active';
							}
						?>"> <span class="icon"> <i class="far fa-clock"></i> </span> <span class="text"> <small>Hazırlanıyor</small></span> </div>
						<div class="step <?php
							if($siparisBul[0]["durum"] == 2 OR $siparisBul[0]["durum"] == 3 OR $siparisBul[0]["durum"] == 3){
								echo 'active';
							}
						?>"> <span class="icon"> <i class="fa fa-truck"></i> </span> <span class="text"> <small>Yola Çıktı</small> </span> </div>
						<div class="step <?php
							if($siparisBul[0]["durum"] == 3){
								echo 'active';
							}
						?>"> <span class="icon"> <i class="fa fa-box"></i> </span> <span class="text"><small>Teslim Edildi</small></span> </div>
					</div>
					<ul class="row">
						<li class="col-md-4">
							<a target="_blank" href="<?=url() . $urunBul[0]["SEO"];?>/"><figure class="itemside mb-3">
								<div class="aside"><img src="<?=uploads() .'thumb_'. $urunBul[0]["gorsel"]?>" class="img-sm border"></div>
								<figcaption class="info align-self-center">
									<p class="title"><?=$urunBul[0]["title"];?></p> <span class="text-muted"><?=$siparisBul[0]["tutar"]?>,00 TL</span>
								</figcaption>
							</figure></a>
						</li>
						<li class="col-md-4">
							<a href="#" data-toggle="modal" data-target="#siparisNotu"><figure class="itemside mb-3">
								<div class="aside"><i class="far fa-sticky-note fa-5x"></i></div>
								<figcaption class="info align-self-center">
									<p class="title">Hazır Not Ekle</p> <small class="text-muted">Siparişinizi özelleştirin. </small>
								</figcaption>
							</figure></a>
						</li>
						<li class="col-md-4">
							<h5>Toplam Tutar: <?=$siparisBul[0]["tutar"];?>,00TL <br /> <?php
										if($siparisBul[0]["odemeYontemi"] == 2){
											if($siparisBul[0]["kredikartıOnay"] == 1){
												echo '<span style="color:green;">(<i class="fas fa-check"></i> Ücret tahsil edildi.)</span><br />';
											}else{
												echo '<br /><span style="color:red;">( <i class="fas fa-exclamation-triangle"></i> Ücret kartınızdan tahsil edilemedi. Ürün gönderilemez.)</span><hr /><a href="'.url().'online-siparis?siparisID='.$siparisBul[0]["siparisID"].'"><button class="btn btn-success btn-block"><i class="fas fa-credit-card"></i> Ödeme Yap</button></a>';
											}
										}
									echo 'Ödeme Yöntemi: ';
										odemeYontemi($siparisBul[0]["odemeYontemi"]);
									?></h5>
						</li>
					</ul>
				</div>
			</article>
		</div>
      </section>
      <?php
         include "FOOTER.php";
          ?>
		  <div class="modal fade" id="siparisNotu" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
			  <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header">
					<h5 class="modal-title" id="exampleModalLabel">Hazır Not Ekle</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					  <span aria-hidden="true">&times;</span>
					</button>
				  </div>
				  <div class="modal-body">
					<form action="" method="POST">
						<div class="form-group">
						<select class="form-control form-control-lg input" id="notSelect">
                                    <option value="">Not Seçiniz</option>
									<?php
									$hazirNotlar = $db->query("SELECT * FROM hazirnotlar ORDER BY nGroup DESC");
									$notTtype = '';
										foreach ($hazirNotlar as $nots) {
											  if ($notTtype != $nots['nGroup']) {
												if ($notTtype != '') {
												  echo '</optgroup>';
												}
												echo '<optgroup label="'.ucfirst($nots['nGroup']).'">';
											  }
											  echo '<option value="'.$nots['notDetay'].'">'.htmlspecialchars($nots['notDetay']).'</option>';
											  $notTtype = $nots['nGroup'];    
											}
											if ($notTtype != '') {
											  echo '</optgroup>';
											}
									?>
                                 </select>
                              </div>
							  
							  <div class="form-group">
								<textarea name="mNotu" class="form-control" id="update" cols="30" placeholder="Kendi notunu yaz veya not seç." rows="5"><?=$siparisBul[0]["musterinot"]?></textarea>
                              </div>
						
					
				  </div>
				  <div class="modal-footer">
					<button type="button" class="btn btn-dark btn-sm" data-dismiss="modal">Kapat</button>
					<button type="submit" name="notDegistir" class="btn btn-success btn-sm">Değişikliği Kaydet</button>
				  </div>
				  </form>
				</div>
			  </div>
			</div>
      <script src="<?=theme();?>js/popper.min.js"></script>
      <script src="<?=theme();?>js/bootstrap.min.js"></script>
	  <script type="text/javascript">
		$('#notSelect').change(function(event) {
			$('#update').html($('#notSelect').val());
		}); 
	</script>
   </body>
</html>