<?php
	$siparisDetay = $db->query("SELECT * FROM siparisler WHERE siparisID=?", array(get("siparisID")));
	if(!$siparisDetay){
		header("Location: " . url());
	}
?>
<!doctype html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Kredi Kartı ile Online Öde | <?=title();?></title>
	<meta name="robots" content="noindex">
	<style>
    .paytr-table-cell-head img {height: 20px;display: block;margin: 0 auto;}
    .paytr-table-bold {color: #434d57;font-weight: bold;}
    .paytr-table-toplam{color: #737373;font-size: 12px;}
    .paytr-table-cols > .paytr-table-cell {width: 14%;}
    .paytr-table {max-width: 1000px;margin: 0 auto;display: -webkit-box;display: -ms-flexbox;display: flex;-ms-flex-wrap: wrap;flex-wrap: wrap;padding: 0;font-family: Arial, sans-serif;font-size: 14px;}
    .paytr-table-cell{box-sizing: border-box;-webkit-box-flex: 1;-ms-flex-positive: 1;flex-grow: 1;width: 100%;padding: 0.5em 1em;overflow: hidden;list-style: none;border: solid 1px #ffffff;}
    .paytr-table-cell{text-align: center;margin: -4px 0 0 -4px;background-color: #ffffff;border-color: #f1f1f1;}
    .paytr-table-cell:hover{cursor: default;background-color: #F3F3F3;}
    .paytr-table-cell-head{height: 38px;color: #ffffff;border-color: #f1f1f1;background-color: #ffffff;}
    .no-flexbox .paytr-table{display: block;}
    .no-flexbox .paytr-table > .paytr-table-cell{width: 100%;}
    @media all and (max-width: 700px) {.paytr-table {display: block;}.paytr-table > .paytr-table-cell {font-size: 16px !important;width: 100% !important;}.paytr-table-cell-head img {height: auto;}}
	</style>
</head>
<body>
	<?php
	$merchant_id 	= merchant_id();
	$merchant_key 	= merchant_key();
	$merchant_salt	= merchant_salt();
	#
	## Müşterinizin sitenizde kayıtlı veya form vasıtasıyla aldığınız eposta adresi
	$email = eposta();
	#
	## Tahsil edilecek tutar.
	$payment_amount	= $siparisDetay[0]["tutar"]*100; //9.99 için 9.99 * 100 = 999 gönderilmelidir.
	#
	## Sipariş numarası: Her işlemde benzersiz olmalıdır!! Bu bilgi bildirim sayfanıza yapılacak bildirimde geri gönderilir.
	$merchant_oid = $siparisDetay[0]["siparisID"];
	#
	## Müşterinizin sitenizde kayıtlı veya form aracılığıyla aldığınız ad ve soyad bilgisi
	$user_name = $siparisDetay[0]["adsoyad"];
	#
	## Müşterinizin sitenizde kayıtlı veya form aracılığıyla aldığınız adres bilgisi
	$user_address = $siparisDetay[0]["aliciadres"];
	#
	## Müşterinizin sitenizde kayıtlı veya form aracılığıyla aldığınız telefon bilgisi
	$user_phone = $siparisDetay[0]["telefon"];
	#
	## Başarılı ödeme sonrası müşterinizin yönlendirileceği sayfa
	## !!! Bu sayfa siparişi onaylayacağınız sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
	## !!! Siparişi onaylayacağız sayfa "Bildirim URL" sayfasıdır (Bakınız: 2.ADIM Klasörü).
	$merchant_ok_url = url() . 'siparis-detaylari?siparisID=' . $siparisDetay[0]["siparisID"];
	#
	## Ödeme sürecinde beklenmedik bir hata oluşması durumunda müşterinizin yönlendirileceği sayfa
	## !!! Bu sayfa siparişi iptal edeceğiniz sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
	## !!! Siparişi iptal edeceğiniz sayfa "Bildirim URL" sayfasıdır (Bakınız: 2.ADIM Klasörü).
	$merchant_fail_url = url() . 'siparis-detaylari?siparisID=' . $siparisDetay[0]["siparisID"];
	#
	## Müşterinin sepet/sipariş içeriğ
	$urunSelect = $db->query("SELECT * FROM urunler WHERE ID=?", array($siparisDetay[0]["urunID"]));
	$user_basket = base64_encode(json_encode(array(
		array($urunSelect[0]["title"], $siparisDetay[0]["tutar"], 1)
	)));

	## Kullanıcının IP adresi
	if( isset( $_SERVER["HTTP_CLIENT_IP"] ) ) {
		$ip = $_SERVER["HTTP_CLIENT_IP"];
	} elseif( isset( $_SERVER["HTTP_X_FORWARDED_FOR"] ) ) {
		$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
	} else {
		$ip = $_SERVER["REMOTE_ADDR"];
	}

	## !!! Eğer bu örnek kodu sunucuda değil local makinanızda çalıştırıyorsanız
	## buraya dış ip adresinizi (https://www.whatismyip.com/) yazmalısınız. Aksi halde geçersiz paytr_token hatası alırsınız.
	$user_ip=$ip;
	##

	## İşlem zaman aşımı süresi - dakika cinsinden
	$timeout_limit = "30";

	## Hata mesajlarının ekrana basılması için entegrasyon ve test sürecinde 1 olarak bırakın. Daha sonra 0 yapabilirsiniz.
	$debug_on = 1;

    ## Mağaza canlı modda iken test işlem yapmak için 1 olarak gönderilebilir.
    $test_mode = 0;

	$no_installment	= 0; // Taksit yapılmasını istemiyorsanız, sadece tek çekim sunacaksanız 1 yapın

	## Sayfada görüntülenecek taksit adedini sınırlamak istiyorsanız uygun şekilde değiştirin.
	## Sıfır (0) gönderilmesi durumunda yürürlükteki en fazla izin verilen taksit geçerli olur.
	$max_installment = 0;

	$currency = "TL";
	
	####### Bu kısımda herhangi bir değişiklik yapmanıza gerek yoktur. #######
	$hash_str = $merchant_id .$user_ip .$merchant_oid .$email .$payment_amount .$user_basket.$no_installment.$max_installment.$currency.$test_mode;
	$paytr_token=base64_encode(hash_hmac('sha256',$hash_str.$merchant_salt,$merchant_key,true));
	$post_vals=array(
			'merchant_id'=>$merchant_id,
			'user_ip'=>$user_ip,
			'merchant_oid'=>$merchant_oid,
			'email'=>$email,
			'payment_amount'=>$payment_amount,
			'paytr_token'=>$paytr_token,
			'user_basket'=>$user_basket,
			'debug_on'=>$debug_on,
			'no_installment'=>$no_installment,
			'max_installment'=>$max_installment,
			'user_name'=>$user_name,
			'user_address'=>$user_address,
			'user_phone'=>$user_phone,
			'merchant_ok_url'=>$merchant_ok_url,
			'merchant_fail_url'=>$merchant_fail_url,
			'timeout_limit'=>$timeout_limit,
			'currency'=>$currency,
            'test_mode'=>$test_mode
		);
	
	$ch=curl_init();
	curl_setopt($ch, CURLOPT_URL, "https://www.paytr.com/odeme/api/get-token");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1) ;
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_vals);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
	curl_setopt($ch, CURLOPT_TIMEOUT, 20);
	$result = @curl_exec($ch);

	if(curl_errno($ch))
		die("PAYTR IFRAME connection error. err:".curl_error($ch));

	curl_close($ch);
	
	$result=json_decode($result,1);
		
	if($result['status']=='success'){
		$token=$result['token'];
	}else{
		$newSD = $siparisDetay[0]["siparisID"].rand(1,99);
		$guncelle = $db->query("UPDATE siparisler SET siparisID = ? WHERE siparisID = ?", array($newSD, $siparisDetay[0]["siparisID"]));
		header("Location: ". url() . "online-siparis?siparisID=" . $newSD);
		die("PAYTR IFRAME failed. reason:".$result['reason']);
	}
	#########################################################################

	?>
    <script src="https://www.paytr.com/js/iframeResizer.min.js"></script>
    <iframe src="https://www.paytr.com/odeme/guvenli/<?php echo $token;?>" id="paytriframe" frameborder="0" scrolling="no" style="width: 100%;"></iframe>
	<script>iFrameResize({},'#paytriframe');</script>		<div id="paytr_taksit_tablosu"></div>
	<script src="https://www.paytr.com/odeme/taksit-tablosu?token=3766f98858023ad74fddef3207beecc5b2a1d92b7c71a2fc617912ab8ce7d863&resp=1&merchant_id=118580&amount=<?=$siparisDetay[0]["tutar"];?>&taksit=0&tumu=0"></script>
</body>
</html>
