<!DOCTYPE html>
<html lang="tr-TR">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>Banka Bilgileri | <?=title();?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="<?=admintheme();?>dist/bootstrap/css/bootstrap.min.css">
<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/style.css">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/font-awesome/css/font-awesome.min.css">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/et-line-font/et-line-font.css">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/themify-icons/themify-icons.css">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/simple-lineicon/simple-line-icons.css">
<!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->

</head>
<body class="skin-blue sidebar-mini">
<div class="wrapper boxed-wrapper">
  <?php
	require_once("HEADER.php");
	?>
  <div class="content-wrapper"> 
    <!-- Main content -->
    <div class="content">
      <div class="card">
      <div class="card-body">
        <h4 class="text-black">Banka Hesapları</h4>
		<p>Bu alandan sitenizde yayınlanacak olan bankaları yönetebilirsiniz. </p>
		<?php
		if(gisset("eklendi")){
			adminmesaj1("Yeni banka hesabı başarıyla eklendi.");
		}elseif(gisset("silindi")){
			adminmesaj1("Banka hesabı başarıyla silindi.");
		}
	  ?>
		<?php
			if(pisset("yenihesapekle")){
				if(post("iban") != "" OR post("hesapsahibi") != ""){
					$yeniilceekle = $db->query("INSERT INTO bankahesaplari(bankaadi, hesapsahibi, IBAN) VALUES(?,?,?)", array(post("banka"), post("hesapsahibi"), post("iban")));
					if($yeniilceekle){
						header("Location: " . adminurl() . '?pages=bankabilgileri&eklendi');
					}
			}else{
				adminmesaj0("Lütfen Hesap Sahibi ve IBAN alanlarını doldurunuz.");
			}
			}
		?>
		<form action="" method="POST">
        <div class="row">
          <div class="col-lg-4">
            <fieldset class="form-group">
              <label>Banka Seçiniz</label>
              <select name="banka" class="form-control" id="" required>
				<option value="">Seçiniz</option>
				<option value="Akbank">Akbank</option>
				<option value="Alternatifbank">Alternatifbank</option>
				<option value="Anadolubank">Anadolubank</option>
				<option value="Arap Türk Bankası">Arap Türk Bankası</option>
				<option value="Bank Ekspress">Bank Ekspress</option>
				<option value="Bayındır Bank">Bayındır Bank</option>
				<option value="Citibank">Citibank</option>
				<option value="Credit Suisse FB.">Credit Suisse FB.</option>
				<option value="Denizbank">Denizbank</option>
				<option value="Diler Yatırım Bankası">Diler Yatırım Bankası</option>
				<option value="Dışbank">Dışbank</option>
				<option value="Finans Bank">Finans Bank</option>
				<option value="Takas ve Saklama Bankası">Takas ve Saklama Bankası</option>
				<option value="İnterbank">İnterbank</option>
				<option value="Kentbank">Kentbank</option>
				<option value="Koçbank">Koçbank</option>
				<option value="MNG Bank">MNG Bank</option>
				<option value="Nurol Yatırım Bankası">Nurol Yatırım Bankası</option>
				<option value="Oyak Bank">Oyak Bank</option>
				<option value="Pamukbank">Pamukbank</option>
				<option value="Park Yatırım Bankası">Park Yatırım Bankası</option>
				<option value="Sınai Yatırım Bankası">Sınai Yatırım Bankası</option>
				<option value="Şekerbank">Şekerbank</option>
				<option value="Tekfen Bank">Tekfen Bank</option>
				<option value="ICBC Turkey Bank A.Ş.">ICBC Turkey Bank A.Ş.</option>
				<option value="The Chase Manhattan Bank">The Chase Manhattan Bank</option>
				<option value="Turkish Bank">Turkish Bank</option>
				<option value="Türk Dışbank">Türk Dışbank</option>
				<option value="Türk Ekonomi Bankası">Türk Ekonomi Bankası</option>
				<option value="Türk Eximbank">Türk Eximbank</option>
				<option value="Türkbank">Türkbank</option>
				<option value="Türk Ticaret Bankası">Türk Ticaret Bankası</option>
				<option value="TCMB">TCMB</option>
				<option value="TC Ziraat Bankası">TC Ziraat Bankası</option>
				<option value="Türkiye Emlak Bankası">Türkiye Emlak Bankası</option>
				<option value="Türkiye Garanti Bankası">Türkiye Garanti Bankası</option>
				<option value="Türkiye Halk Bankası">Türkiye Halk Bankası</option>
				<option value="Türkiye İş Bankası">Türkiye İş Bankası</option>
				<option value="Türkiye Kalkınma Bankası">Türkiye Kalkınma Bankası</option>
				<option value="Türkiye Sınai Kalkınma Bankası">Türkiye Sınai Kalkınma Bankası</option>
				<option value="Yaşarbank">Yaşarbank</option>
				<option value="Vakıflar Bankası">Vakıflar Bankası</option>
				<option value="Yapı ve Kredi Bankası">Yapı ve Kredi Bankası</option>
			  </select>
            </fieldset>
          </div>
		  <div class="col-lg-4">
            <fieldset class="form-group">
              <label>Hesap Sahibi</label>
              <input class="form-control" type="text" name="hesapsahibi">
            </fieldset>
          </div>
		  <div class="col-lg-4">
            <fieldset class="form-group">
              <label>IBAN Numarası</label>
              <input class="form-control" type="text" name="iban">
            </fieldset>
          </div>
		  <div class="col-lg-12">
			<button type="submit" name="yenihesapekle" class="btn btn-rounded btn-primary">Yeni Banka Hesabı Ekle</button>
          </div>
        </div>
        </form>
      </div>
	  </div>
     <div class="card">
        <div class="card-body">
          <h4>Kayıtlı Banka Hesapları</h4>
          <div class="table-responsive">
              <table class="table table-bordered text-center">
                <thead>
                  <tr>
                    <th scope="col">#</th>
                    <th scope="col">Banka Adı</th>
                    <th scope="col">Hesap Sahibi</th>
                    <th scope="col">IBAN Numarası</th>
                    <th scope="col">İşlem</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
					$sira = 0;
					$bankaHesaplari = $db->query("SELECT * FROM bankahesaplari");
					foreach($bankaHesaplari as $row){
						$sira++;
						echo '<tr>
                    <th scope="row">'.$sira.'</th>
                    <td>'.$row["bankaadi"].'</td>
                    <td>'.$row["hesapsahibi"].'</td>
                    <td>'.$row["IBAN"].'</td>
					<td><a href="' . adminurl() . '?pages=sil&bankaSil&id=' . $row["ID"] . '"><button type="button" class="btn btn-rounded btn-dark" onclick="return confirm(\'Bu banka hesabı siteden silinecektir, silinsin mi?\')">Sil</button></a></td>
                  </tr>';
					}
				  ?>
                </tbody>
              </table>
            </div>
        </div>
      </div>
    </div>
    <!-- /.content --> 
  </div>
  <footer class="main-footer">
    <div class="pull-right hidden-xs">Version 1.0</div>
    Copyright © <?=date('Y');?> <?=title();?> | Tüm Hakkı Saklıdır.</footer>
</div>
<script src="<?=admintheme();?>dist/js/jquery.min.js"></script> 
<script src="<?=admintheme();?>dist/bootstrap/js/bootstrap.min.js"></script>  
<script src="<?=admintheme();?>dist/js/adminkit.js"></script>
</body>
</html>