<!DOCTYPE html>
<html lang="tr-TR">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>Genel Bakış | <?=title();?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="<?=admintheme();?>dist/bootstrap/css/bootstrap.min.css">
<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/style.css">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/font-awesome/css/font-awesome.min.css">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/et-line-font/et-line-font.css">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/themify-icons/themify-icons.css">
<link rel="stylesheet" href="<?=admintheme();?>dist/css/simple-lineicon/simple-line-icons.css">
<link rel="stylesheet" href="<?=admintheme();?>dist/plugins/datatables/css/dataTables.bootstrap.min.css">
<!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->

</head>
<body class="skin-blue sidebar-mini">
<div class="wrapper boxed-wrapper">
  <?php require_once("HEADER.php");?>  
  <div class="content-wrapper"> 
    
    <!-- Main content -->
    <div class="content">
      <div class="row">
        <div class="col-lg-3">
          <div class="tile-progress tile-pink">
            <div class="tile-header">
			<?php
				$buaykazanc = $db->query("SELECT tutar FROM siparisler WHERE durum=? AND MONTH(siparisTarihi) = MONTH(CURDATE())", array(3));
				foreach($buaykazanc as $buaykazancrow){
					$kazancTutarTopla = $kazancTutarTopla + $buaykazancrow["tutar"];
				}
			?>
              <h5>Kazanç</h5>
              <h3><?php echo $kazancTutarTopla;?><i class="fa fa-try"></i></h3>
            </div>
            <div class="tile-progressbar"> <span data-fill="100%" style="width: 100%;"></span> </div>
            <div class="tile-footer">
              <h5> <span class="pct-counter">Bu ay elde edilen kazaç</h5>
            </div>
          </div>
        </div>
        <div class="col-lg-3">
          <div class="tile-progress tile-red">
            <div class="tile-header">
			<?php
				$toplamKazanc = $db->query("SELECT tutar FROM siparisler WHERE durum=?", array(3));
				foreach($toplamKazanc as $kazancToplamTutarToplarow){
					$kazancToplamTutarTopla = $kazancToplamTutarTopla + $kazancToplamTutarToplarow["tutar"];
				}
			?>
              <h5>Kazanç</h5>
              <h3><?php if($kazancToplamTutarTopla){ echo $kazancToplamTutarTopla;}else{echo '0';}?><i class="fa fa-try"></i></h3>
            </div>
            <div class="tile-progressbar"> <span data-fill="100%" style="width: 100%;"></span> </div>
            <div class="tile-footer">
              <h5> <span class="pct-counter">Bütün ay elde edilen kazanç</h5>
            </div>
          </div>
        </div>
        <div class="col-lg-3">
          <div class="tile-progress tile-cyan">
            <div class="tile-header">
			<?php
				$toplamUrunYayin = $db->query("SELECT * FROM urunler WHERE durum=?", array(1));
			?>
              <h5>Ürün</h5>
              <h3><?=count($toplamUrunYayin);?></h3>
            </div>
            <div class="tile-progressbar"> <span data-fill="100%" style="width: 100%;"></span> </div>
            <div class="tile-footer">
              <h5> <span class="pct-counter">Yayında olan ürün sayısı</h5>
            </div>
          </div>
        </div>
        <div class="col-lg-3">
          <div class="tile-progress tile-aqua">
            <div class="tile-header">
			<?php
				$toplamUrunYayinOlmayan = $db->query("SELECT * FROM urunler WHERE durum=?", array(0));
			?>
              <h5>Ürün</h5>
              <h3><?=count($toplamUrunYayinOlmayan);?></h3>
            </div>
            <div class="tile-progressbar"> <span data-fill="100%" style="width: 100%;"></span> </div>
            <div class="tile-footer">
              <h5> <span class="pct-counter">Yayında olmayan ürün sayısı</h5>
            </div>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-lg-12 m-b-3">
          <div class="box box-info">
            <div class="box-header with-border p-t-1">
              <h3 class="box-title text-black">Onay Bekleyen Siparişler</h3>
              <div class="pull-right"> <a href="<?=adminurl() . '?pages=onaybekleyensiparisler';?>">Onay Bekleyen Siparişler <i class="fa fa-long-arrow-right"></i></a> </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <div class="table-responsive">
                  <table id="example1" class="table table-bordered table-striped">
                <thead>
                <tr class="text-center">
                  <th>Ürün Özeti</th>
                  <th>Sipariş Özeti</th>
                  <th>Ödeme Durumu</th>
                  <th>İşlem</th>
                </tr>
                </thead>
                <tbody>
				
                <?php
					//onay bekleyen siparişler = 0
					//kargo bekleyen siparişler = 1
					//teslim bekleyen siparişler = 2
					//tamamlanan siparişler = 3
					//iptal edilen siparişler = 4
					$kontrol = 0;
					$siparisler = $db->query("SELECT * FROM siparisler WHERE durum=?", array(0, 1));
					foreach($siparisler as $row){
						$kontrol++;
						$urun = $db->query("SELECT * FROM urunler WHERE ID=?", array($row["urunID"]));
				?>
				<tr class="text-center">
                  <td class="align-middle"><?php adminSiparisDurumu($row["durum"]);?> <br /> <?=$row["siparisTarihi"];?> <br /> <hr /> <?php
					echo '<a target="_blank" href="'.url() . $urun[0]["SEO"] . '/'.'"><img height="100" src="'.uploads() .'admin_'. $urun[0]["gorsel"].'" alt="" /></a>';
				  ?></td>
                  <td class="align-middle">
					<b>Alıcının Ad Soyad:</b> <?=$row["aliciadsoyad"]?> <br />
					<b>Alıcının Telefon Numarası:</b> <?=$row["alicitelefon"]?><br />
					<b>Alıcının Adresi:</b> <?=$row["aliciadres"]?> <hr />
					<b>Göndericinin Ad soyadı:</b> <?=$row["adsoyad"]?> <br />
					<b>Göndericinin Telefon Numarası:</b> <?=$row["telefon"]?> 
				  </td>
                  <td class="align-middle">
					<b>Ödeme Yöntemi: </b> <?=adminOdemeYontemi($row["odemeYontemi"]);?>
						<?php
							if($row["odemeYontemi"] == 2){
								echo '<br /><b>Ödeme Durumu:</b>';
								if($row["kredikartıOnay"] == 1){
									echo '<span class="label label-success">Ödeme Alındı.</span>';
								}else{
									echo '<span class="label label-danger">Ödeme Alınamadı.</span>';
								}
							}
						?>
					<hr />
					<b>Toplam Ödenecek Tutar: </b> <?=$row["tutar"];?>,00 TL
				  </td>
                  <td class="align-middle"><button data-toggle="modal" data-target="#myModal<?=$kontrol;?>" class="btn btn-sm btn-warning"><i class="fa fa-camera"></i> Görsel Ekle</button><br /><br /> <a href="<?=adminurl() . '?pages=guncelle&siparisOnayla&id=' . $row["ID"];?>"><button type="button" class="btn btn-sm btn-success" onclick="return confirm('Bu sipariş onaylanacaktır, onaylansın mı?')"><i class="fa fa-check"></i> Onayla</button></a><br /><br />
				  <a href="<?=adminurl() . '?pages=guncelle&siparisIptal&id=' . $row["ID"];?>"><button type="button" class="btn btn-sm btn-danger" onclick="return confirm('Bu sipariş iptal edilecektir, iptal edilsin mı?')"><i class="fa fa-thumbs-down"></i> İptal Et</button></a><br /><br />
				  <a href="<?=adminurl() . '?pages=siparisDetaylari&id=' . $row["ID"];?>"><button type="button" class="btn btn-sm btn-primary"><i class="fa fa-external-link"></i> İncele</button></a><br /><br />
				  <a href="<?=adminurl() . '?pages=siparisDuzelt&id=' . $row["ID"];?>"><button type="button" class="btn btn-sm btn-secondary"><i class="fa fa-pencil"></i> Düzelt</button></a><br /><br />
				  <a href="<?=adminurl() . '?pages=sil&siparisSil&id=' . $row["ID"];?>"><button type="button" class="btn btn-sm btn-dark" onclick="return confirm('Bu sipariş silinecektir, silinsin mi?')"><i class="fa fa-remove"></i> Sil</button></a></td>
                </tr>
				<div class="modal fade" id="myModal<?=$kontrol;?>" role="dialog">
											<div class="modal-dialog">
											
											  <!-- Modal content-->
											  <div class="modal-content">
									<div class="modal-header">
									  <button type="button" class="close" data-dismiss="modal">&times;</button>
									</div>
									<div class="modal-body">
									   <form class="form-horizontal" action="" enctype="multipart/form-data" method="POST" role="form">
										<input type="hidden" name="siparisNumarasi" value="<?=$row["ID"];?>" />
										<input type="hidden" name="adsoyadkullanici" value="<?=$row["adsoyad"];?>" />
										<div class="form-group">
											<label for="kargoID">Görsel Seç</label>
											<input type="file" name="yapilanGorsel" />
										</div>
										<button class="btn btn-info" name="gorselEkle" type="submit">Yeni Görseli Ekle</button>
									  </form>
									</div>
									<div class="modal-footer">
									  <button type="button" class="btn btn-default" data-dismiss="modal">Kapat</button>
									</div>
																				  </div>
																				  
																				</div>
																			  </div>
				<?php
					}
				?>
                
                </tbody>
                <tfoot>
                <tr class="text-center">
                  <th>Ürün Özeti</th>
                  <th>Sipariş Özeti</th>
                  <th>Ödeme Durumu</th>
                  <th>İşlem</th>
                </tr>
                </tfoot>
              </table>
                  </div>
              <!-- /.table-responsive --> 
            </div>
          </div>
        </div>
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.content --> 
  </div>
  <!-- /.content-wrapper -->
   <footer class="main-footer">
    <div class="pull-right hidden-xs">Version 1.0</div>
    Copyright © <?=date('Y');?> <?=title();?> | Tüm Hakkı Saklıdır.</footer>
</div>
<script src="<?=admintheme();?>dist/js/jquery.min.js"></script>
<script src="<?=admintheme();?>dist/plugins/popper/popper.min.js"></script>
<script src="<?=admintheme();?>dist/bootstrap/js/bootstrap.min.js"></script>
<script src="<?=admintheme();?>dist/js/adminkit.js"></script>
<script src="<?=admintheme();?>dist/plugins/datatables/jquery.dataTables.min.js"></script> 
<script src="<?=admintheme();?>dist/plugins/datatables/dataTables.bootstrap.min.js"></script> 
<script>
  $(function () {
    $('#example1').DataTable()})
</script>

<script src="<?=admintheme();?>dist/plugins/table-expo/filesaver.min.js"></script>
<script src="<?=admintheme();?>dist/plugins/table-expo/xls.core.min.js"></script>
</body>
</html>