<?php
function permalink($str, $options = array())
{
    $str = mb_convert_encoding((string)$str, 'UTF-8', mb_list_encodings());
    $defaults = array(
        'delimiter' => '-',
        'limit' => null,
        'lowercase' => true,
        'replacements' => array(),
        'transliterate' => true
    );
    $options = array_merge($defaults, $options);
    $char_map = array(
        // Latin
        'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A', 'Æ' => 'AE', 'Ç' => 'C',
        'È' => 'E', 'É' => 'E', 'Ê' => 'E', 'Ë' => 'E', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I',
        'Ð' => 'D', 'Ñ' => 'N', 'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O', 'Ő' => 'O',
        'Ø' => 'O', 'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ü' => 'U', 'Ű' => 'U', 'Ý' => 'Y', 'Þ' => 'TH',
        'ß' => 'ss',
        'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a', 'å' => 'a', 'æ' => 'ae', 'ç' => 'c',
        'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i',
        'ð' => 'd', 'ñ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'o', 'ő' => 'o',
        'ø' => 'o', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ü' => 'u', 'ű' => 'u', 'ý' => 'y', 'þ' => 'th',
        'ÿ' => 'y',
        // Latin symbols
        '©' => '(c)',
        // Greek
        'Α' => 'A', 'Β' => 'B', 'Γ' => 'G', 'Δ' => 'D', 'Ε' => 'E', 'Ζ' => 'Z', 'Η' => 'H', 'Θ' => '8',
        'Ι' => 'I', 'Κ' => 'K', 'Λ' => 'L', 'Μ' => 'M', 'Ν' => 'N', 'Ξ' => '3', 'Ο' => 'O', 'Π' => 'P',
        'Ρ' => 'R', 'Σ' => 'S', 'Τ' => 'T', 'Υ' => 'Y', 'Φ' => 'F', 'Χ' => 'X', 'Ψ' => 'PS', 'Ω' => 'W',
        'Ά' => 'A', 'Έ' => 'E', 'Ί' => 'I', 'Ό' => 'O', 'Ύ' => 'Y', 'Ή' => 'H', 'Ώ' => 'W', 'Ϊ' => 'I',
        'Ϋ' => 'Y',
        'α' => 'a', 'β' => 'b', 'γ' => 'g', 'δ' => 'd', 'ε' => 'e', 'ζ' => 'z', 'η' => 'h', 'θ' => '8',
        'ι' => 'i', 'κ' => 'k', 'λ' => 'l', 'μ' => 'm', 'ν' => 'n', 'ξ' => '3', 'ο' => 'o', 'π' => 'p',
        'ρ' => 'r', 'σ' => 's', 'τ' => 't', 'υ' => 'y', 'φ' => 'f', 'χ' => 'x', 'ψ' => 'ps', 'ω' => 'w',
        'ά' => 'a', 'έ' => 'e', 'ί' => 'i', 'ό' => 'o', 'ύ' => 'y', 'ή' => 'h', 'ώ' => 'w', 'ς' => 's',
        'ϊ' => 'i', 'ΰ' => 'y', 'ϋ' => 'y', 'ΐ' => 'i',
        // Turkish
        'Ş' => 'S', 'İ' => 'I', 'Ç' => 'C', 'Ü' => 'U', 'Ö' => 'O', 'Ğ' => 'G',
        'ş' => 's', 'ı' => 'i', 'ç' => 'c', 'ü' => 'u', 'ö' => 'o', 'ğ' => 'g',
        // Russian
        'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ё' => 'Yo', 'Ж' => 'Zh',
        'З' => 'Z', 'И' => 'I', 'Й' => 'J', 'К' => 'K', 'Л' => 'L', 'М' => 'M', 'Н' => 'N', 'О' => 'O',
        'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'H', 'Ц' => 'C',
        'Ч' => 'Ch', 'Ш' => 'Sh', 'Щ' => 'Sh', 'Ъ' => '', 'Ы' => 'Y', 'Ь' => '', 'Э' => 'E', 'Ю' => 'Yu',
        'Я' => 'Ya',
        'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd', 'е' => 'e', 'ё' => 'yo', 'ж' => 'zh',
        'з' => 'z', 'и' => 'i', 'й' => 'j', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n', 'о' => 'o',
        'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u', 'ф' => 'f', 'х' => 'h', 'ц' => 'c',
        'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sh', 'ъ' => '', 'ы' => 'y', 'ь' => '', 'э' => 'e', 'ю' => 'yu',
        'я' => 'ya',
        // Ukrainian
        'Є' => 'Ye', 'І' => 'I', 'Ї' => 'Yi', 'Ґ' => 'G',
        'є' => 'ye', 'і' => 'i', 'ї' => 'yi', 'ґ' => 'g',
        // Czech
        'Č' => 'C', 'Ď' => 'D', 'Ě' => 'E', 'Ň' => 'N', 'Ř' => 'R', 'Š' => 'S', 'Ť' => 'T', 'Ů' => 'U',
        'Ž' => 'Z',
        'č' => 'c', 'ď' => 'd', 'ě' => 'e', 'ň' => 'n', 'ř' => 'r', 'š' => 's', 'ť' => 't', 'ů' => 'u',
        'ž' => 'z',
        // Polish
        'Ą' => 'A', 'Ć' => 'C', 'Ę' => 'e', 'Ł' => 'L', 'Ń' => 'N', 'Ó' => 'o', 'Ś' => 'S', 'Ź' => 'Z',
        'Ż' => 'Z',
        'ą' => 'a', 'ć' => 'c', 'ę' => 'e', 'ł' => 'l', 'ń' => 'n', 'ó' => 'o', 'ś' => 's', 'ź' => 'z',
        'ż' => 'z',
        // Latvian
        'Ā' => 'A', 'Č' => 'C', 'Ē' => 'E', 'Ģ' => 'G', 'Ī' => 'i', 'Ķ' => 'k', 'Ļ' => 'L', 'Ņ' => 'N',
        'Š' => 'S', 'Ū' => 'u', 'Ž' => 'Z',
        'ā' => 'a', 'č' => 'c', 'ē' => 'e', 'ģ' => 'g', 'ī' => 'i', 'ķ' => 'k', 'ļ' => 'l', 'ņ' => 'n',
        'š' => 's', 'ū' => 'u', 'ž' => 'z'
    );
    $str = preg_replace(array_keys($options['replacements']), $options['replacements'], $str);
    if ($options['transliterate']) {
        $str = str_replace(array_keys($char_map), $char_map, $str);
    }
    $str = preg_replace('/[^\p{L}\p{Nd}]+/u', $options['delimiter'], $str);
    $str = preg_replace('/(' . preg_quote($options['delimiter'], '/') . '){2,}/', '$1', $str);
    $str = mb_substr($str, 0, ($options['limit'] ? $options['limit'] : mb_strlen($str, 'UTF-8')), 'UTF-8');
    $str = trim($str, $options['delimiter']);
    return $options['lowercase'] ? mb_strtolower($str, 'UTF-8') : $str;
}

class PasswordHash {
	var $itoa64;
	var $iteration_count_log2;
	var $portable_hashes;
	var $random_state;

	function __construct($iteration_count_log2, $portable_hashes)
	{
		$this->itoa64 = './0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';

		if ($iteration_count_log2 < 4 || $iteration_count_log2 > 31)
			$iteration_count_log2 = 8;
		$this->iteration_count_log2 = $iteration_count_log2;

		$this->portable_hashes = $portable_hashes;

		$this->random_state = microtime();
		if (function_exists('getmypid'))
			$this->random_state .= getmypid();
	}

	function PasswordHash($iteration_count_log2, $portable_hashes)
	{
		self::__construct($iteration_count_log2, $portable_hashes);
	}

	function get_random_bytes($count)
	{
		$output = '';
		if (@is_readable('/dev/urandom') &&
		    ($fh = @fopen('/dev/urandom', 'rb'))) {
			$output = fread($fh, $count);
			fclose($fh);
		}

		if (strlen($output) < $count) {
			$output = '';
			for ($i = 0; $i < $count; $i += 16) {
				$this->random_state =
				    md5(microtime() . $this->random_state);
				$output .= md5($this->random_state, TRUE);
			}
			$output = substr($output, 0, $count);
		}

		return $output;
	}

	function encode64($input, $count)
	{
		$output = '';
		$i = 0;
		do {
			$value = ord($input[$i++]);
			$output .= $this->itoa64[$value & 0x3f];
			if ($i < $count)
				$value |= ord($input[$i]) << 8;
			$output .= $this->itoa64[($value >> 6) & 0x3f];
			if ($i++ >= $count)
				break;
			if ($i < $count)
				$value |= ord($input[$i]) << 16;
			$output .= $this->itoa64[($value >> 12) & 0x3f];
			if ($i++ >= $count)
				break;
			$output .= $this->itoa64[($value >> 18) & 0x3f];
		} while ($i < $count);

		return $output;
	}

	function gensalt_private($input)
	{
		$output = '$P$';
		$output .= $this->itoa64[min($this->iteration_count_log2 +
			((PHP_VERSION >= '5') ? 5 : 3), 30)];
		$output .= $this->encode64($input, 6);

		return $output;
	}

	function crypt_private($password, $setting)
	{
		$output = '*0';
		if (substr($setting, 0, 2) === $output)
			$output = '*1';

		$id = substr($setting, 0, 3);
		# We use "$P$", phpBB3 uses "$H$" for the same thing
		if ($id !== '$P$' && $id !== '$H$')
			return $output;

		$count_log2 = strpos($this->itoa64, $setting[3]);
		if ($count_log2 < 7 || $count_log2 > 30)
			return $output;

		$count = 1 << $count_log2;

		$salt = substr($setting, 4, 8);
		if (strlen($salt) !== 8)
			return $output;

		$hash = md5($salt . $password, TRUE);
		do {
			$hash = md5($hash . $password, TRUE);
		} while (--$count);

		$output = substr($setting, 0, 12);
		$output .= $this->encode64($hash, 16);

		return $output;
	}

	function gensalt_blowfish($input)
	{
		$itoa64 = './ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

		$output = '$2a$';
		$output .= chr(ord('0') + $this->iteration_count_log2 / 10);
		$output .= chr(ord('0') + $this->iteration_count_log2 % 10);
		$output .= '$';

		$i = 0;
		do {
			$c1 = ord($input[$i++]);
			$output .= $itoa64[$c1 >> 2];
			$c1 = ($c1 & 0x03) << 4;
			if ($i >= 16) {
				$output .= $itoa64[$c1];
				break;
			}

			$c2 = ord($input[$i++]);
			$c1 |= $c2 >> 4;
			$output .= $itoa64[$c1];
			$c1 = ($c2 & 0x0f) << 2;

			$c2 = ord($input[$i++]);
			$c1 |= $c2 >> 6;
			$output .= $itoa64[$c1];
			$output .= $itoa64[$c2 & 0x3f];
		} while (1);

		return $output;
	}

	function HashPassword($password)
	{
		$random = '';

		if (CRYPT_BLOWFISH === 1 && !$this->portable_hashes) {
			$random = $this->get_random_bytes(16);
			$hash =
			    crypt($password, $this->gensalt_blowfish($random));
			if (strlen($hash) === 60)
				return $hash;
		}

		if (strlen($random) < 6)
			$random = $this->get_random_bytes(6);
		$hash =
		    $this->crypt_private($password,
		    $this->gensalt_private($random));
		if (strlen($hash) === 34)
			return $hash;
		return '*';
	}

	function CheckPassword($password, $stored_hash)
	{
		$hash = $this->crypt_private($password, $stored_hash);
		if ($hash[0] === '*')
			$hash = crypt($password, $stored_hash);
		return $hash === $stored_hash;
	}
}

function sipariskodu() {
		$alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
		$pass = array(); //remember to declare $pass as an array
		$alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
		for ($i = 0; $i < 12; $i++) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
		}
		return implode($pass); //turn the array into a string
		
}

function request_path() {
  static $path;
  if (isset($path)) {
    return $path;
  }
  if (isset($_GET['q']) && is_string($_GET['q'])) {
    $path = $_GET['q'];
  }
  elseif (isset($_SERVER['REQUEST_URI'])) {
    $request_path = strtok($_SERVER['REQUEST_URI'], '?');
    $base_path_len = strlen(rtrim(dirname($_SERVER['SCRIPT_NAME']), '\\/'));
    $path = substr(urldecode($request_path), $base_path_len + 1);
    if ($path == basename($_SERVER['PHP_SELF'])) {
      $path = '';
    }
  }
  else {
    $path = '';
  }
  $path = trim($path, '/');
  return $path;
}
 
function url(){
	return URL;
}
function title(){
	return TITLE;
}
function telefon(){
	return TELEFON;
}
function fax(){
	return FAX;
}
function eposta(){
	return EPOSTA;
}
function adres(){
	return ADRES;
}
function hakkimizda(){
	return HAKKIMIZDA;
}
function description(){
	return DESCRIPTION;
}
function siteharitakodu(){
	return SITEHARITAKODU;
}
function mobillogo(){
	return uploads() . MOBILLOGO;
}
function facebook(){
	return FACEBOOK;
}
function instagram(){
	return INSTAGRAM;
}
function twitter(){
	return TWITTER;
}
function whatsapp(){
	return WHATSAPP;
}
function merchant_id(){
	return merchant_id;
}
function merchant_key(){
	return merchant_key;
}
function merchant_salt(){
	return merchant_salt;
}
function siteAnalytics(){
	return siteAnalytics;
}
function favicon(){
	return uploads() . FAVICON;
}
function firsanurunID(){
	return FIRSATURUN;
}
function siterenk(){
	return SITERENK;
}
function theme(){
	return url() . 'theme/assets/';
}
function uploads(){
	return url() . 'uploads/';
}
function logo(){
	return uploads() . LOGO;
}
function admintheme(){
	return url() . 'theme/ADMIN/';
}
function adminurl(){
	return url() . 'secure';
}
function uploaddir(){
	return $_SERVER['DOCUMENT_ROOT'] . '/uploads/';
}
function pisset($value=""){
	if ($_POST) {
		if($value==""){
			if ($_POST) {
				return true;
			}else{
				return false;
			}
		}else{
			if (isset($_POST[$value])) {
				return true;
			}else{
				return false;
			}
		}
	}else{
		return false;
	}
}
function gisset($value=""){
	if ($_GET) {
		if($value==""){
			if ($_GET) {
				return true;
			}else{
				return false;
			}
		}else{
			if (isset($_GET[$value])) {
				return true;
			}else{
				return false;
			}
		}
	}else{
		return false;
	}
}

function post($value)
{
	if (isset($_POST[$value])) {
		return trim($_POST[$value]);
	}else{
		return false;
	}
}
function get($value)
{
	if (isset($_GET[$value])) {
		return trim($_GET[$value]);
	}else{
		return false;
	}
}

function usertokenUret($length = 60) {
    $key = '';
    $keys = array_merge(range(0, 9), range('a', 'z'));

    for ($i = 0; $i < $length; $i++) {
        $key .= $keys[array_rand($keys)];
    }

    return $key;
}

function GetIP(){
 if(getenv("HTTP_CLIENT_IP")) {
 $ip = getenv("HTTP_CLIENT_IP");
 } elseif(getenv("HTTP_X_FORWARDED_FOR")) {
 $ip = getenv("HTTP_X_FORWARDED_FOR");
 if (strstr($ip, ',')) {
 $tmp = explode (',', $ip);
 $ip = trim($tmp[0]);
 }
 } else {
 $ip = getenv("REMOTE_ADDR");
 }
 return $ip;
}


function adminMenuactive($url1, $url2){
	if($url1 == $url2){
		echo 'active';
	}
}

function sideBarMenuActive($url1, $url2){
	if($url1 == $url2){
		return 'active';
	}
}

function adminSiparisDurumu($durum){
	if($durum == 0){
		echo '<span class="label label-primary">Onay Bekleyen Sipariş</span>';
	}elseif($durum == 1){
		echo '<span class="label label-info">Kargo Bekleyen Sipariş</span>';
	}elseif($durum == 2){
		echo '<span class="label label-warning">Teslim Bekleyen Sipariş</span>';
	}elseif($durum == 3){
		echo '<span class="label label-success">Tamamlanan Sipariş</span>';
	}elseif($durum == 4){
		echo '<span class="label label-danger">İptal Edilen Sipariş</span>';
	}
}
function adminUrunDurumu($durum){
	if($durum == 0){
		echo '<span class="label label-danger">Ürün Satışa Kapalı</span>';
	}elseif($durum == 1){
		echo '<span class="label label-success">Ürün Satışa Açık</span>';
	}
}
function adminOdemeYontemi($durum){
	if($durum == 1){
		echo '<span class="label label-info">Kapıda Ödeme</span>';
	}elseif($durum == 2){
		echo '<span class="label label-info">Kredi Kartı</span>';
	}elseif($durum == 3){
		echo '<span class="label label-info">EFT / Havale</span>';
	}elseif($durum == 0){
		echo '<span class="label label-danger">Vazgeçilmiş Sipariş</span>';
	}
}
function adminOdemeYontemi2($durum){
	if($durum == 1){
		return 'Kapıda Ödeme';
	}elseif($durum == 2){
		return 'Kredi Kartı';
	}elseif($durum == 3){
		return 'EFT / Havale';
	}
}

function adminmesaj1($mesaj = "İşlem başarıyla gerçekleştirildi."){
	echo '<div class="alert alert-success alert-dismissible fade show" role="alert"> <strong>Başarılı!</strong> ' .$mesaj. ' <button type="button" class="close" data-dismiss="alert" aria-label="Close"> <span aria-hidden="true">×</span> </button>
          </div>';
}
function adminmesaj0($mesaj = "İşlem gerçekleştirilemedi."){
	echo '<div class="alert alert-error alert-dismissible fade show" role="alert"> <strong>Hatalı!</strong> ' .$mesaj. ' <button type="button" class="close" data-dismiss="alert" aria-label="Close"> <span aria-hidden="true">×</span> </button>
          </div>';
}

function odemeYontemi($yontem){
	if($yontem == 1){
		echo 'Kapıda Ödeme';
	}elseif($yontem == 2){
		echo 'Kredi Kartı İle Online Ödeme';
	}elseif($yontem == 3){
		echo 'Havale veya EFT';
	}else{
		echo 'Ödeme Yönteminde Sorun Var';
	}
}
function siparisDurumu($durum){
	if($durum == 0){
		return 'Yeni Sipariş - Onay Bekliyor';
	}elseif($durum == 1){
		return 'Ürün Onaylandı - Hazırlanıyor';
	}elseif($durum == 2){
		return 'Ürün Yola Çıktı';
	}elseif($durum == 3){
		return 'Ürün Alıcıya Teslim Edildi';
	}elseif($durum == 4){
		return 'Sipariş İptal Edildi';
	}elseif($durum == 5){
		return 'Sipariş Tamamlandı';
	}else{
		return 'Ürün Durumunda Sorun Var';
	}
}

function hizliTanitim(){
	echo '<section class="product-description">
         <div class="container">
               <div class="row">
               	<div class="col-md-12">
               		<ul class="widget">
               			<li>
               				<strong>TAZE</strong> ÇİÇEKLER
               			</li>
               			<li>
               				<strong>GÜVENLİ</strong> ALIŞVERİŞ
               			</li>
               			<li>
               				<strong>ÜCRETSİZ</strong> TESLİMAT
               			</li>
               			<li>
               				<strong>1200\'DEN FAZLA</strong> BAYİ AĞI
               			</li>
               		</ul>
               	</div>
               </div>
         </div>
      </section>';
}


function sms_gonder($Url,$Deger){
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $Url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1) ;
	curl_setopt($ch, CURLOPT_POSTFIELDS, $Deger);
	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	$Cikti = curl_exec($ch);
	curl_close($ch);
	return $Cikti;
}    

function SMSTurkceKarakter($s){
	$bulunacak = array('ç','Ç','ı','İ','ğ','Ğ','ü','ö','Ş','ş','Ö','Ü'); 
	$degistir  = array('c','C','i','I','g','G','u','o','S','s','O','U'); 
	$sonuc=str_replace($bulunacak, $degistir, $s);
	return $sonuc;
}

function yorumKontrol($yontem){
	if($yontem == 0){
		echo '<span class="badge badge-danger">Yayından Kaldırıldı</span>';
	}elseif($yontem == 1){
		echo '<span class="badge badge-success">Yayında</span>';
	}
}

function gelenMesajKontrol($yontem){
	if($yontem == 0){
		echo '<span class="badge badge-danger">Okunmadı</span>';
	}elseif($yontem == 1){
		echo '<span class="badge badge-success">Okundu</span>';
	}
}